-- input tables
$approved_domens = '{{ approved_domens_table }}';
$metrika_watchlog = '{{ metrika_bs_watchlog }}' || '/' || $date;

-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --

$get_yuid = ($uniqid) -> ( CAST($force_null($uniqid) AS UInt64) );


$preparsed_watchlog =
    SELECT
        $get_yuid(uniqid) AS yuid,
        $get_duid(domainuserid, headerargs) AS duid,
        $uniqid_was_changed(browserinfo) AS uniqid_was_changed,
        $ClientUserID(params) AS id2,
        $get_domain(url) AS domain,
        counterid,
    FROM $metrika_watchlog
    WHERE
        $get_domain(url) NOT IN {'', 'localhost'}
        AND $ClientUserID(params) IS NOT NULL
        AND (
            ($get_yuid(uniqid) IS NOT NULL AND NOT $uniqid_was_changed(browserinfo))
            OR
            (
                $get_duid(domainuserid, headerargs) IS NOT NULL
                AND ($get_yuid(uniqid) IS NULL OR $get_yuid(uniqid) == $get_duid(domainuserid, headerargs))
            )
        )
    ;


DEFINE ACTION $parse_client_user_id_as_id($approved_domens, $id_type, $is_valid, $normalize) AS
    $ids_from_log =
    SELECT
        IdType::YANDEXUID() AS id1Type,
        id2,
        domain,
        AGG_LIST_DISTINCT(counterid) AS counterids,
    FROM $preparsed_watchlog
    WHERE
        $is_valid(id2)
        AND yuid IS NOT NULL AND NOT uniqid_was_changed
    GROUP BY yuid, $normalize(id2) AS id2, domain

    UNION ALL

    SELECT
        IdType::DUID() AS id1Type,
        id2,
        domain,
        AGG_LIST_DISTINCT(counterid) AS counterids,
    FROM $preparsed_watchlog
    WHERE
        $is_valid(id2)
        AND duid IS NOT NULL AND (yuid IS NULL OR yuid == duid)
    GROUP BY duid, $normalize(id2) AS id2, domain;


    $ids_from_log_with_soup =
    SELECT
        log.id1Type AS id1Type,
        log.domain AS domain,
        log.domain IN $approved_domens AS is_approved_domain,
        log.counterids AS counterids,
        IF(soup.id2 IS NULL, FALSE, TRUE) AS found_id2_in_soup
    FROM $ids_from_log AS log
    LEFT JOIN ANY $get_typed_soup_vertices($id_type) AS soup
    USING(id2);


    INSERT INTO @metrics
    SELECT
        $date AS dt,
        id1Type,
        $id_type() AS id2Type,
        LogSource::WATCH_LOG() AS logSource,
        SourceType::METRICA_USER_PARAMS() AS sourceType,
        domain,
        MAX(is_approved_domain) AS is_approved_domain,
        SOME(counterids) AS counterids,
        AVG(found_id2_in_soup) AS found_id2_in_soup_ratio,
        COUNT(*) AS count,
    FROM $ids_from_log_with_soup
    GROUP BY domain, id1Type;

END DEFINE;

-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --

$EMAIL_APPROVED_DOMENS = SELECT ToSet(AGGREGATE_LIST(domen)) FROM $approved_domens WHERE email;
$EMAIL_MD5_APPROVED_DOMENS = SELECT ToSet(AGGREGATE_LIST(domen)) FROM $approved_domens WHERE email_md5;
$EMAIL_SHA256_APPROVED_DOMENS = SELECT ToSet(AGGREGATE_LIST(domen)) FROM $approved_domens WHERE email_sha256;
$PHONE_APPROVED_DOMENS = SELECT ToSet(AGGREGATE_LIST(domen)) FROM $approved_domens WHERE phone;

$check_phone = ($client_user_id) -> ( Identifiers::IsValidPhone($client_user_id) AND $client_user_id REGEXP @@^[\+78]@@ );


DO $parse_client_user_id_as_id(
    $EMAIL_APPROVED_DOMENS, IdType::EMAIL, Identifiers::IsValidEmail, Identifiers::NormalizeEmail);

DO $parse_client_user_id_as_id(
    $EMAIL_MD5_APPROVED_DOMENS, IdType::EMAIL_MD5, Identifiers::IsValidEmailMd5, Identifiers::NormalizeEmailMd5);

DO $parse_client_user_id_as_id(
    $EMAIL_SHA256_APPROVED_DOMENS, IdType::EMAIL_SHA256, Identifiers::IsValidEmailSha256, Identifiers::NormalizeEmailSha256);

DO $parse_client_user_id_as_id(
    $PHONE_APPROVED_DOMENS, IdType::PHONE, $check_phone, Identifiers::NormalizePhone);
