import logging
import os
import sys

import yt.wrapper as yt
from crypta.graph.mrcc.lib import MRConnectedComponentsYT


def main():
    logging.basicConfig(level='INFO')

    client = yt.YtClient(proxy=os.getenv('YT_PROXY'), token=os.getenv('YT_TOKEN'))
    client.proxy = os.getenv('YT_PROXY')
    client.token = os.getenv('YT_TOKEN')
    client.pool = None
    client.transaction_id = None

    with client.Transaction() as tx:
        client.transaction_id = str(tx.transaction_id)
        mrcc = MRConnectedComponentsYT(client)
        mrcc.find_connected_components(sys.argv[1])
