from tempfile import NamedTemporaryFile
import os
import yt.wrapper as yt
import logging
import library.python.resource as rs
from luigi.cmdline import luigi_run

from crypta.graph.mrcc.bin.tasks import *  # noqa
import crypta.graph.mrcc.bin.config as config

LUIGI_CONFIG = NamedTemporaryFile()
os.environ['LUIGI_CONFIG_PATH'] = LUIGI_CONFIG.name
logger = logging.getLogger(__name__)


def init_logger():
    logging.config.dictConfig(dict(
        formatters=dict(
            default=dict(
                format="[%(levelname)-4s][%(name)s.%(funcName)s:%(lineno)d] "
                       "%(asctime)-15s: %(message)s",
            )
        ),
        handlers=dict(
            console={
                'level': 'INFO',
                'class': 'logging.StreamHandler',
                'formatter': 'default',
            }
        ),
        root=dict(
            level='INFO',
            handlers=['console'],
        ),
        disable_existing_loggers=False,
        version=1,
        loggers={
            'yt.packages.requests': {
                'level': 'WARNING',
            }
        }
    ))


def prepare_environment():
    yt.config.set_proxy(config.Yt.PROXY)
    yt.config['token'] = config.Yt.TOKEN


def main():
    """
    do not forget install luigi and start luigid on 8083 port
    and dont forget "apt-get install yabs-graphite-client" for grafana
    and dont forget "apt-get install yabs-graphite-client-full" for grafana
    and create special config
    and start yabs-graphite-client
    :return:
    """
    init_logger()
    prepare_environment()
    LUIGI_CONFIG.write(rs.find('/config/luigi.cfg'))
    LUIGI_CONFIG.flush()
    luigi_run()
