PRAGMA yt.InferSchema;

$mrcc = (
    SELECT
        u, v,
        u AS `{component_id}`
        -- DENSE_RANK() OVER w AS `{component_id}`
    FROM `{intermediate}`
    -- WINDOW w AS (ORDER BY u)
);

$v_data = (
    SELECT
        v_col,
        SOME(v_data) AS v_data
    FROM (
        SELECT
            v_col,
            v_data
        FROM (
            SELECT
                AsList(
                    `{u_name}`, `{v_name}`
                ) AS v_col,
                TableRow() AS v_data
            FROM `{source}`
        ) FLATTEN LIST BY v_col
    ) GROUP BY v_col
);


INSERT INTO `{destination}` WITH TRUNCATE
SELECT
    mrcc.u AS `{u_name}`,
    mrcc.v AS `{v_name}`,
    mrcc.`{component_id}` AS `{component_id}`,
    v_data.v_data AS data
FROM $mrcc AS mrcc
INNER JOIN $v_data AS v_data
ON (mrcc.v == v_data.v_col)
ORDER BY `{u_name}`, `{v_name}`
;


COMMIT;


DROP TABLE `{intermediate}`;
