pragma yt.InferSchema;
pragma yt.TemporaryCompressionCodec = "none";
pragma yt.PublishedCompressionCodec = "none";

$input = (
    select *
    from `{source}`
);

$directed_edges = (
    select u, v
    from $input
    union all
    select v as u, u as v
    from $input
);

$min_neighbor_large_star = (
    select u, 
           min(v) as min_v,
           count_if(v > u) as greater_than_u
    from $directed_edges
    group by u
);

$large_star_changes = (
    select coalesce(sum(greater_than_u), 0)
    from $min_neighbor_large_star
    where min_v < u and greater_than_u > 0
);

$large_star = (
    select edges.v as u,
           least(edges.u, min_neighbor.min_v) as v
    from $directed_edges as edges
         inner join $min_neighbor_large_star as min_neighbor
             on (edges.u == min_neighbor.u)
    where edges.v > edges.u
);

$large_to_small = (
    -- after large star all u's are larger than v's
    select u, v
    from $large_star
);

$min_neighbor_small_star = (
    select u, 
           min(v) as min_v,
           count(*) as smaller_than_u
    from $large_to_small
    group by u
);

$small_star_changes = (
    select coalesce(sum(smaller_than_u - 1), 0)
    from $min_neighbor_small_star
    where smaller_than_u > 1
);

$small_star = (
    select min_neighbor.min_v as u,
           edges.v as v
    from ( select u, v
           from $large_to_small
           union all
           select u, u as v
           from $min_neighbor_small_star
         ) as edges
         inner join $min_neighbor_small_star as min_neighbor
             on (min_neighbor.u = edges.u)
    where min_neighbor.min_v < edges.v
);

insert into `{destination}`
with truncate (
    select *
    from $small_star
);

$total_changes = (
    select $small_star_changes + $large_star_changes
);

select $total_changes as total_changes,
       $large_star_changes as large_star_changes,
       $small_star_changes as small_star_changes
;
