#pragma once
#include <chrono>
#include <ctime>
#include <iostream>

namespace NConnectedComponents {
    using chrono_clock = std::chrono::high_resolution_clock;
    using chrono_timepoint = std::chrono::time_point<std::chrono::high_resolution_clock>;

    class TMeasure {
        public:
            TMeasure(IOutputStream& logger = Cout, const TString& name = "") : Logger(logger), Name(name) {
                StartTime = chrono_clock::now();
            }
            ~TMeasure() {
               Logger << ".." << Name << " Time: "
               << std::chrono::duration_cast<std::chrono::seconds>(chrono_clock::now() - StartTime).count()
               << " sec" <<  Endl;
            }
        private:
            IOutputStream& Logger;
            TString Name;
            chrono_timepoint StartTime;
    };
} // namespace NConnectedComponents
