#pragma once
#include <mapreduce/yt/interface/client.h>
#include <mapreduce/yt/interface/operation.h>
#include <mapreduce/yt/common/config.h>
#include <iostream>

namespace NConnectedComponents {
    static const TString BASE_SCRIPT_NAME = "MRCC";

    NYT::TOperationOptions SetAdditionalSpecToOperationOptions(NYT::TOperationOptions& options, const NYT::TNode& spec) {
        auto optionsSpec = options.Spec_.GetOrElse(NYT::TNode());
        for (const auto& item: spec.AsMap()) {
            optionsSpec(item.first, item.second);
        }
        return options.Spec(optionsSpec);
    }

    NYT::TOperationOptions AddScriptName(NYT::TOperationOptions& options, const TString scriptName = BASE_SCRIPT_NAME, bool force = true) {
        auto spec = options.Spec_.GetOrElse(NYT::TNode());
        NYT::TNode annotations;
        if (spec.HasValue() && spec.HasKey("annotations")) {
            annotations = spec["annotations"];
        }
        if (!force) {
            if (annotations.HasValue() && annotations.HasKey("script_name")) {
                return options;
            }
        }
        annotations("script_name", scriptName);
        return SetAdditionalSpecToOperationOptions(
            options,
            NYT::TNode()("annotations", annotations)
        );
    }

    NYT::TOperationOptions AddPool(NYT::TOperationOptions& options, const TString& pool) {
        return SetAdditionalSpecToOperationOptions(options, NYT::TNode()("pool", pool));
    }

    NYT::TOperationOptions GetCommonOperationOptions(const NYT::TOperationOptions& options) {
        NYT::TOperationOptions commonOptions(options);
        return AddScriptName(commonOptions, BASE_SCRIPT_NAME, false);
    }

    NYT::TOperationOptions GetCommonOperationOptions() {
        NYT::TOperationOptions options;
        return GetCommonOperationOptions(options);
    }

    struct TYT {
        NYT::IClientBasePtr Client;
        NYT::TOperationOptions CommonOperationOptions{};
        TYT(NYT::IClientBasePtr client) : Client(client), CommonOperationOptions(GetCommonOperationOptions()) {}
        TYT(NYT::IClientBasePtr client, const NYT::TOperationOptions& options) :
            Client(client),
            CommonOperationOptions(GetCommonOperationOptions(options)) {}

        NYT::TOperationOptions GetCommonOperationOptionsWithJoinedSpec(const NYT::TNode& spec) const {
            NYT::TOperationOptions options(CommonOperationOptions);
            return SetAdditionalSpecToOperationOptions(options, spec);
        }
    };

};
