#pragma once
#include <crypta/graph/mrcc_opt/lib/mrcc.h>
#include <crypta/graph/mrcc_opt/lib/data.h>
#include <crypta/graph/mrcc_opt/lib/yt.h>
#include <mapreduce/yt/interface/client.h>
#include <mapreduce/yt/interface/operation.h>
#include <mapreduce/yt/common/config.h>


namespace NConnectedComponents {


bool FindComponents(
        const TString& proxy, const TString& token, const TString& transactionId, const TString& pool,
        const TString& source,
        const TString& destination,
        const TString& workdir,
        const TString& previousLabels,
        const TVector<TString>& edgeSourceFields,
        const TVector<TString>& edgeTargetFields,
        const TVector<TString>& vertexFields,
        const TString& componentField,
        int maxIterationsCount,
        bool startPrepare,
        bool finishPrepare,
        const TString& scriptName) {

    char *argv[] = {};
    NYT::Initialize(0, argv);
    NYT::TConfig::Get()->UseClientProtobuf = false;
    if (token) {
        NYT::TConfig::Get()->Token = token;
    }
    auto options = GetCommonOperationOptions();
    options.JobCommandPrefix("Y_PYTHON_ENTRY_POINT=\"crypta.lib.python.native_yt.entry.point\" ");

    if (pool) {
        AddPool(options, pool);
    }
    if (scriptName) {
        AddScriptName(options, scriptName);
    }

    auto client = NYT::CreateClient(proxy, NYT::TCreateClientOptions());
    auto ptr = client->AttachTransaction(GetGuid(transactionId));
    TYT yt(ptr, options);

    TGeneralDataView dataView(
        edgeSourceFields, edgeTargetFields, vertexFields, componentField
    );
    TDataPaths dataPaths(dataView, source, destination, workdir, previousLabels);
    auto mrcc = TOptimizedStars<TGeneralDataView, ui64>(yt, dataPaths, Cout);
    auto result = mrcc.Run(maxIterationsCount, startPrepare, finishPrepare);
    return result;
}

} // namespace NConnectedComponents
