from six import ensure_binary
from util.generic.string cimport TString
from util.generic.vector cimport TVector
from libcpp cimport bool


cdef extern from "crypta/graph/mrcc_opt/python/native/mrcc.h"  namespace "NConnectedComponents":
    bool FindComponents(\
            const TString& proxy, const TString& token, const TString& transactionId, const TString& pool,\
            const TString& source, \
            const TString& destination, \
            const TString& workdir, \
            const TString& previousLabels, \
            const TVector[TString]& edgeSourceFields, \
            const TVector[TString]& edgeTargetFields, \
            const TVector[TString]& vertexFields, \
            const TString& componentField, \
            int maxIterationsCount, \
            bool startPrepare, \
            bool finishPrepare,
            const TString& scriptName) nogil


cdef TVector[TString] fields_to_TVector(fields) except *:
    cdef TVector[TString] result
    for each in fields:
        result.push_back(ensure_binary(each))
    return result


def find_components(str proxy, str token, str transaction_id, str pool,
                    str source, str destination, str workdir, str previous_labels,
                    list edge_first_fields, list edge_second_fields, list vertex_fields, str component_field,
                    int max_iterations_count, bool with_start_preparing, bool with_finish_preparing,
                    str script_name = "MRCC_PY"
                    ):
    cdef TString _proxy = ensure_binary(proxy)
    cdef TString _token = ensure_binary(token)
    cdef TString _transaction_id = ensure_binary(transaction_id)
    cdef TString _source = ensure_binary(source)
    cdef TString _destination = ensure_binary(destination)
    cdef TString _workdir = ensure_binary(workdir)
    cdef TString _previous_labels = ensure_binary(previous_labels)
    cdef TVector[TString] _edge_first_fields = fields_to_TVector(edge_first_fields)
    cdef TVector[TString] _edge_second_fields = fields_to_TVector(edge_second_fields)
    cdef TVector[TString] _vertex_fields = fields_to_TVector(vertex_fields)
    cdef TString _component_field = ensure_binary(component_field)
    cdef TString _pool = ensure_binary(pool)
    cdef TString _script_name = ensure_binary(script_name)
    cdef bool result;
    with nogil:
        result = FindComponents(_proxy, _token, _transaction_id, _pool, _source, _destination, _workdir, _previous_labels,
                                _edge_first_fields, _edge_second_fields, _vertex_fields, _component_field,
                                max_iterations_count, with_start_preparing, with_finish_preparing, _script_name)
    return result
