import os

from library.python.step.client import Client
from crypta.graph.orchestration.step.action_configs_client import StepActionConfigs

# disable https warnings
import requests
from requests.packages.urllib3.exceptions import InsecureRequestWarning

requests.packages.urllib3.disable_warnings(InsecureRequestWarning)

kHOUR = 60 * 60


def main():
    sandbox_token = os.getenv('SANDBOX_TOKEN')
    if not sandbox_token:
        raise Exception('set SANDBOX_TOKEN')

    step_client = Client(env='production', token=sandbox_token, num_retries=20)

    action_configs = StepActionConfigs(step_client, sandbox_owner='CRYPTA')
    register_configs(action_configs)
    action_configs.update_configs()


def make_indevice_config(env, task='CRYPTA_SOUPY_INDEVICE'):
    require = {
        'CRYPTA_SOUPY_INDEVICE': 'IndeviceStuffIsReady',
        'CRYPTA_SOUPY_INDEVICE_FAST': 'IndeviceStuffIsReadyFast',
    }
    if task in ['CRYPTA_SOUPY_INDEVICE', 'CRYPTA_SOUPY_INDEVICE_FAST']:
        return {
            'description': 'Make indevice from soup (%s)' % env,
            'event_deps': [{
                'name': 'cryptaTaskEvent',
                'params': {
                    'taskType': require[task],
                    'date': '~',
                    'taskStatus': 'SUCCESS',
                    'environment': env
                },
            }],
            'action_type': 'SANDBOX_TASK',
            'task_type': task,
            'task_params': {
                'notifications': notifications(env),
                'kill_timeout': 40 * kHOUR if task == 'CRYPTA_SOUPY_INDEVICE' else 10 * kHOUR
            },
            'custom_fields': {
                'environment': env
            }
        }


def notifications(env):
    return {
        'stable': [{
            "transport": "email",
            "statuses": ["FAILURE", "EXCEPTION", "TIMEOUT", "EXPIRED"],
            "recipients": [
                "artembelov",
                "mskorokhod",
                "crypta-cryptaid@yandex-team.ru",
            ]
        }]
    }.get(env, [])


def register_configs(action_configs):
    action_configs.add('crypta.graph.publish.lib.soup_link_publisher.CopySoup', {
        'description': 'Make links to soup tables after CRYPTA_GRAPH_PREPARE_SOUP_YAML is finished',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'CRYPTA_GRAPH_PREPARE_SOUP_YAML',
                'taskStatus': 'SUCCESS',
                'environment': 'stable'
            },
        }],
        'action_type': 'SANDBOX_TASK',
        'task_type': 'CRYPTA_GRAPH_TASK_RUNNER',
        'task_params': {
            'notifications': notifications('stable'),
            'kill_timeout': 15 * kHOUR
        },
        'custom_fields': {
            'environment': 'stable',
            'task_name': 'crypta.graph.publish.lib.soup_link_publisher.CopySoup',
            'Use proto args': False,
            'Force': False
        }
    })

    action_configs.add('CRYPTA_GRAPH_PREPARE_SOUP_YAML', {
        'description': 'Prepare soup for matching after soup processing is finished',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'V2IsReadyFast',
                'date': '~',
                'taskStatus': 'SUCCESS',
                'environment': 'stable'
            },
        }],
        'action_type': 'SANDBOX_TASK',
        'task_type': 'CRYPTA_GRAPH_PREPARE_SOUP_YAML',
        'task_params': {
            'notifications': notifications('stable'),
            'kill_timeout': 20 * kHOUR
        },
        'custom_fields': {
            'environment': 'stable'
        }
    })

    action_configs.add('CRYPTA_GRAPH_PREPARE_SOUP_YAML_TEST', {
        'description': 'Prepare soup for matching after soup processing is finished',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'V2IsReadyFast',
                'date': '~',
                'taskStatus': 'SUCCESS',
                'environment': 'testing'
            },
        }],
        'action_type': 'SANDBOX_TASK',
        'task_type': 'CRYPTA_GRAPH_PREPARE_SOUP_YAML',
        'custom_fields': {
            'environment': 'testing'
        }
    })

    action_configs.add('CRYPTA_GRAPH_PREPARE_SOUP_DYNAMIC_YAML', {
        'description': 'Run creating dynamic tables after soup is prepared',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'CRYPTA_GRAPH_PREPARE_SOUP_YAML',
                'taskStatus': 'SUCCESS',
                'environment': 'stable',
                'date': '~'
            },
        }],
        'action_type': 'SANDBOX_TASK',
        'task_type': 'CRYPTA_GRAPH_PREPARE_SOUP_DYNAMIC_YAML',
        'task_params': {
            'notifications': notifications('stable'),
        },
        'custom_fields': {
            'environment': 'stable',
            'config_file': 'config.yaml'
        }
    })

    action_configs.add('CRYPTA_GRAPH_HUMAN_MATCHING_YAML', {
        'description': 'Run human matching after soup is prepared',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'CRYPTA_GRAPH_PREPARE_SOUP_YAML',
                'taskStatus': 'SUCCESS',
                'environment': 'stable',
                'date': '~'
            },
        }],
        'action_type': 'SANDBOX_TASK',
        'task_type': 'CRYPTA_GRAPH_HUMAN_MATCHING_YAML',
        'task_params': {
            'notifications': notifications('stable'),
        },
        'custom_fields': {
            'environment': 'stable',
            'config_file': 'config-prod.yaml',
            'copy_to_prod': 'false'
        }
    })

    action_configs.add('CRYPTA_GRAPH_HUMAN_MATCHING_PUBLISH', {
        'description': 'Check metrics on new matching and publish matching output if metrics is OK',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'CRYPTA_GRAPH_HUMAN_MATCHING_YAML',
                'taskStatus': 'SUCCESS',
                'environment': 'stable',
                'is_experiment': 'false'
            },
        }],
        'action_type': 'SANDBOX_SCHEDULER',
        'scheduler_id': 18726
    })

    action_configs.add('CRYPTA_GRAPH_HUMAN_MATCHING_BACKUP', {
        'description': 'Make backups of human matching vertices table and clean outdated backups',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'CRYPTA_GRAPH_HUMAN_MATCHING_PUBLISH',
                'taskStatus': 'SUCCESS',
                'environment': 'stable'
            },
        }],
        'action_type': 'SANDBOX_SCHEDULER',
        'scheduler_id': 17848
    })

    action_configs.add('CRYPTA_GRAPH_HUMAN_MATCHING_BACKUP_NEIGHBOURS', {
        'description': 'Make backups of human matching components neighbours table and clean outdated backups',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'CRYPTA_GRAPH_HUMAN_MATCHING_PUBLISH',
                'taskStatus': 'SUCCESS',
                'environment': 'stable'
            },
        }],
        'action_type': 'SANDBOX_SCHEDULER',
        'scheduler_id': 42888
    })

    action_configs.add('CRYPTA_GRAPH_HUMAN_MATCHING_BACKUP_INDEVICE', {
        'description': 'Make backups of soupy indevice',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'CRYPTA_SOUPY_INDEVICE',
                'taskStatus': 'SUCCESS',
                'environment': 'stable',
                'date': '~',
            },
        }],
        'action_type': 'SANDBOX_SCHEDULER',
        'scheduler_id': 42889
    })

    action_configs.add('CRYPTA_GRAPH_SOUP_COMPONENTS', {
        'description': 'Compute mrcc components on fresh soup',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'CRYPTA_GRAPH_PREPARE_SOUP_YAML',
                'taskStatus': 'SUCCESS',
                'environment': 'stable'
            },
        }],
        'action_type': 'SANDBOX_SCHEDULER',
        'scheduler_id': 13998
    })

    action_configs.add('CRYPTA_GRAPH_RANDOM_SAMPLE_SOUP', {
        'description': 'Run random sample of soup after soup is prepared',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'CRYPTA_GRAPH_SOUP_COMPONENTS',
                'taskStatus': 'SUCCESS',
                'environment': 'stable'
            },
        }],
        'action_type': 'SANDBOX_SCHEDULER',
        'scheduler_id': 12321,
        'enabled': False
    })

    action_configs.add('CRYPTA_GRAPH_STAFF_SAMPLE_SOUP', {
        'description': 'Run staff sample of soup after soup is prepared',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'CRYPTA_GRAPH_SOUP_COMPONENTS',
                'taskStatus': 'SUCCESS',
                'environment': 'stable'
            },
        }],
        'action_type': 'SANDBOX_TASK',
        'task_type': 'CRYPTA_GRAPH_SAMPLE_SOUP',
        'task_params': {
            'description': 'Staff sampling of MRCC soup components'
        },
        'custom_fields': {
            'environment': 'stable',
            'mode': 'staff',
            'components_table': '//home/crypta/production/state/graph/v2/soup_cc/components',
            'output_edges_table': '//home/crypta/production/state/graph/v2/soup/cooked/sample/soup_edges.staff',
            'output_properties_table': '//home/crypta/production/state/graph/v2/soup/cooked/sample/vertices_properties.staff'
        },
        'enabled': False
    })

    action_configs.add('CRYPTA_GRAPH_RANDOM_SAMPLE_HUMAN_MATCHING_YAML', {
        'description': 'Run human matching on random-sample of soup',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'CRYPTA_GRAPH_SAMPLE_SOUP',
                'taskStatus': 'SUCCESS',
                'environment': 'stable',
                'mode': 'random'
            },
        }],
        'action_type': 'SANDBOX_TASK',
        'task_type': 'CRYPTA_GRAPH_HUMAN_MATCHING_YAML',
        'task_params': {
            'description': 'Run human matching on random-sample of soup'
        },
        'custom_fields': {
            'environment': 'testing',
            'config_file': 'config-sample-random.yaml'
        },
        'enabled': False
    })

    action_configs.add('CRYPTA_GRAPH_STAFF_SAMPLE_HUMAN_MATCHING_YAML', {
        'description': 'Run human matching on staff-sample of soup',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'CRYPTA_GRAPH_SAMPLE_SOUP',
                'taskStatus': 'SUCCESS',
                'environment': 'stable',
                'mode': 'staff'
            },
        }],
        'action_type': 'SANDBOX_SCHEDULER',
        'scheduler_id': 16628,
        'enabled': False
    })

    action_configs.add('CRYPTA_GRAPH_METRICS_V1', {
        'description': 'Run calc Crypta metrics after matching v1 is ready.',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'CopyVerticesToDict',
                'taskStatus': 'SUCCESS',
                'environment': 'stable'
            },
        }],
        'action_type': 'SANDBOX_SCHEDULER',
        'scheduler_id': 10727
    })

    action_configs.add('CRYPTA_GRAPH_METRICS_V2', {
        'description': 'Run calc Crypta metrics after matching v2 is ready.',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'CRYPTA_GRAPH_HUMAN_MATCHING_PUBLISH',
                'taskStatus': 'SUCCESS',
                'environment': 'stable'
            },
        }],
        'action_type': 'SANDBOX_SCHEDULER',
        'scheduler_id': 10728
    })

    action_configs.add('crypta.graph.matching.direct.lib.indevice_main_task.IndeviceMainTask', {
        'description': 'Computing indevice tables by types after human matching is done',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'CRYPTA_GRAPH_HUMAN_MATCHING_PUBLISH',
                'taskStatus': 'SUCCESS',
                'environment': 'stable'
            },
        }],
        'action_type': 'SANDBOX_TASK',
        'task_type': 'CRYPTA_GRAPH_TASK_RUNNER',
        'task_params': {
            'notifications': notifications('stable'),
            'kill_timeout': 40 * kHOUR
        },
        'custom_fields': {
            'environment': 'stable',
            'task_name': 'crypta.graph.matching.direct.lib.indevice_main_task.IndeviceMainTask'
        }
    })

    action_configs.add('CRYPTA_GRAPH_EXPORT_PRODUCTION', {
        'description': 'PRODUCTION Export graphs after human matching is done',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'CRYPTA_GRAPH_HUMAN_MATCHING_PUBLISH',
                'taskStatus': 'SUCCESS',
                'environment': 'stable'
            },
        }],
        'action_type': 'SANDBOX_SCHEDULER',
        'scheduler_id': 6293,
        'enabled': False
    })

    action_configs.add('CRYPTA_GRAPH_EXPORT_TESTING', {
        'description': 'TESTING Export graphs after human matching is done',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'CRYPTA_GRAPH_HUMAN_MATCHING_PUBLISH',
                'taskStatus': 'SUCCESS',
                'environment': 'stable'
            },
        }],
        'action_type': 'SANDBOX_SCHEDULER',
        'scheduler_id': 6292,
        'enabled': False
    })

    action_configs.add('CRYPTA_HH_HH_COMPOSITION', {
        'description': 'Run calc `hh composition` when `hh match` is ready.',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'CRYPTA_HH_HH_MATCH_FINISH',
                'taskStatus': 'SUCCESS',
                'environment': 'stable'
            },
        }],
        'action_type': 'SANDBOX_SCHEDULER',
        'scheduler_id': 12119
    })

    action_configs.add('CRYPTA_HH_HH_MATCH_FINISH', {
        'description': 'Run calc `hh match finish` when `hh match prepare` is ready.',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'CRYPTA_HH_HH_MATCH_PREPARE',
                'taskStatus': 'SUCCESS',
                'environment': 'stable'
            },
        }],
        'action_type': 'SANDBOX_SCHEDULER',
        'scheduler_id': 12851
    })

    action_configs.add('CRYPTA_RUN_BINARY_HOUSEHOLD_METRICS', {
        'description': 'Run calc hh metrics when hh composition is ready.',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'CRYPTA_HH_HH_COMPOSITION',
                'taskStatus': 'SUCCESS',
                'environment': 'stable'
            },
        }],
        'action_type': 'SANDBOX_SCHEDULER',
        'scheduler_id': 10292
    })

    action_configs.add('CRYPTA_UPLOAD_HOUSEHOLD_YT_TO_BB', {
        'description': 'Run upload hh to BB when hh composition is ready.',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'CRYPTA_HH_HH_COMPOSITION',
                'taskStatus': 'SUCCESS',
                'environment': 'stable'
            },
        }],
        'action_type': 'SANDBOX_SCHEDULER',
        'scheduler_id': 19168
    })

    action_configs.add('CRYPTA_SOUPY_INDEVICE_TEST', make_indevice_config('testing', task='CRYPTA_SOUPY_INDEVICE'))
    action_configs.add('CRYPTA_SOUPY_INDEVICE_PROD', make_indevice_config('stable', task='CRYPTA_SOUPY_INDEVICE'))
    action_configs.add('CRYPTA_SOUPY_INDEVICE_FAST_TEST', make_indevice_config('testing', task='CRYPTA_SOUPY_INDEVICE_FAST'))
    action_configs.add('CRYPTA_SOUPY_INDEVICE_FAST_PROD', make_indevice_config('stable', task='CRYPTA_SOUPY_INDEVICE_FAST'))

    action_configs.add('CRYPTA_SOUPY_INDEVICE_METRICS', {
        'description': 'Calculate all the metrics for soupy indevice',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'CRYPTA_SOUPY_INDEVICE',
                'taskStatus': 'SUCCESS',
                'environment': 'stable',
                'date': '~',
            },
        }],
        'action_type': 'SANDBOX_TASK',
        'task_type': 'CRYPTA_SOUPY_INDEVICE_METRICS',
        'task_params': {
            'notifications': notifications('stable'),
            'kill_timeout': 20 * kHOUR
        },
        'custom_fields': {
            'environment': 'stable',
            'date': 'last'
        }
    })

    action_configs.add('CRYPTA_SOUPY_INDEVICE_METRICS_FAST', {
        'description': 'Calculate all the metrics for fast soupy indevice',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'CRYPTA_SOUPY_INDEVICE_FAST',
                'taskStatus': 'SUCCESS',
                'environment': 'stable',
                'date': '~',
            },
        }],
        'action_type': 'SANDBOX_TASK',
        'task_type': 'CRYPTA_SOUPY_INDEVICE_METRICS',
        'task_params': {
            'notifications': notifications('stable'),
            'kill_timeout': 20 * kHOUR
        },
        'custom_fields': {
            'environment': 'stable',
            'date': 'last',
            'kind': 'fast'
        }
    })

    action_configs.add('CRYPTA_GRAPH_SOUPOSTAT', {
        'description': 'Run soupostat after soup components are prepared',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'CRYPTA_GRAPH_SOUP_COMPONENTS',
                'taskStatus': 'SUCCESS',
                'environment': 'stable'
            },
        }],
        'action_type': 'SANDBOX_SCHEDULER',
        'scheduler_id': 16253
    })

    action_configs.add('CRYPTA_GRAPH_EXPERIMENT_METRICS_V2', {
        'description': 'Run experiment calc Crypta metrics',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'CRYPTA_GRAPH_HUMAN_MATCHING_YAML',
                'taskStatus': 'SUCCESS',
                'environment': 'stable',
                'is_experiment': 'true'
            }
        }],
        'action_type': 'SANDBOX_SCHEDULER',
        'scheduler_id': 16772
    })

    action_configs.add('CRYPTA_GRAPH_SOUPOSTAT_METRICS', {
        'description': 'Run soupostat metrics calc',
        'event_deps': [{
            'name': 'cryptaTaskEvent',
            'params': {
                'taskType': 'SoupIsReadyFast',
                'date': '~',
                'taskStatus': 'SUCCESS',
                'environment': 'stable'
            },
        }],
        'action_type': 'SANDBOX_SCHEDULER',
        'scheduler_id': 15364
    })
