from jsondiff import diff


class StepActionConfigs(object):

    def __init__(self, step_client, sandbox_owner):
        self.step_client = step_client
        self.action_configs = dict()
        self.sandbox_owner = sandbox_owner

    def _get_action_config_diff(self, new_config, old_config):
        new_config_copy = dict(new_config)
        old_config_copy = dict(old_config)

        # some fields are set at server side, we need to exclude it from diff
        default_optional_fields = {
            'semaphores': [],
            'custom_params': dict(),
            'enabled': True
        }
        # some fields
        technical_fields = ['author', '_id']

        for k, v in old_config_copy.items():
            if k in default_optional_fields and default_optional_fields[k] == v and k not in new_config:
                del old_config_copy[k]
            if k in technical_fields:
                del old_config_copy[k]

        return diff(old_config_copy, new_config_copy, syntax='explicit')

    def _create_or_update_action_config(self, uniq_id, config):
        # put uniq id to config custom fields for later search
        if config['action_type'] == 'SANDBOX_TASK':
            config['custom_fields'] = config.get('custom_fields', dict())
            config['custom_fields']['crypta_action_uniq_id'] = uniq_id

            config['task_params'] = config.get('task_params', dict())
            config['task_params']['owner'] = self.sandbox_owner

            existing_configs = self.step_client.get_configs(
                custom_fields__crypta_action_uniq_id=uniq_id
            )
        elif config['action_type'] == 'SANDBOX_SCHEDULER':
            existing_configs = self.step_client.get_configs(
                scheduler_id=config['scheduler_id']
            )
        else:
            raise Exception("action_type in not supported: " +
                            config['action_type'])

        if existing_configs and len(existing_configs) > 1:
            raise Exception(
                "Several action configs with the same uniq_id: " + uniq_id)

        if existing_configs:
            existing_config = existing_configs[0]
            config_id = existing_config['_id']

            config_diff = self._get_action_config_diff(config, existing_config)
            if config_diff:
                print 'updating config %s, diff:\n%s' % (config_id, config_diff)
            else:
                print 'updating config %s, no diff' % (config_id)

            self.step_client.update_config(config_id, config)
            print 'config updated %s' % config_id

        else:
            print 'creating config:\n' + str(config)
            config_id = self.step_client.create_config(**config)
            print 'config created ' + str(config_id)
        return config_id

    def add(self, uniq_id, config):
        if uniq_id in self.action_configs:
            raise Exception(
                "Several action configs with the same uniq_id: " + uniq_id)
        self.action_configs[uniq_id] = config

    def update_configs(self):
        for uniq_id, config in self.action_configs.items():
            self._create_or_update_action_config(uniq_id, config)
