from flask import Flask, request
import tvmauth
from tvmauth.exceptions import TvmException

import crypta.graph.pereval.proto.config_pb2 as config
from crypta.lib.python.getoptpb import ParsePbOptions
config = ParsePbOptions(config.TvmCheckerConfig)

TVM_ID = int(config.TvmId)
TVM_ALLOWED_CONSUMERS = [int(x) for x in config.AllowedIds.split(",") if x]
TVM_SECRET = config.TvmSecret


class TicketVerifier:
    def __init__(self, tvm_id, tvm_secret, allowed_consumers):
        self.client = tvmauth.TvmClient(tvmauth.TvmApiClientSettings(
            self_tvm_id=tvm_id,
            enable_service_ticket_checking=True,
            self_secret=tvm_secret,
            dsts={"self": tvm_id},
        ))

        self.allowed_consumers = allowed_consumers

    def verify(self, ticket):
        try:
            st = self.client.check_service_ticket(ticket)
            if (st.src not in self.allowed_consumers):
                return 403, "Src is not in allowed_consumers"
        except TvmException:
            return 403, "Ticket is invalid"

        return 200, "OK"


app = Flask(__name__)


@app.route("/")
def verify():
    code, message = app.verifier.verify(request.headers.get('X-Ya-Service-Ticket', ''))
    return message, str(code)


if __name__ == '__main__':
    assert(TVM_SECRET)
    app.verifier = TicketVerifier(TVM_ID, TVM_SECRET, TVM_ALLOWED_CONSUMERS)

    app.run(
        host='::1',
        port=config.Port,
        debug=config.Debug
    )
