#include <crypta/graph/proxy_exp_stats/lib/request_handler.h>
#include <crypta/graph/proxy_exp_stats/proto/config.pb.h>

#include <crypta/lib/native/cmd_args/parse_pb_options.h>
#include <library/cpp/logger/global/global.h>
#include <library/cpp/neh/neh.h>
#include <library/cpp/neh/rpc.h>
#include <library/cpp/neh/http_common.h>
#include <yt/yt/core/logging/config.h>
#include <yt/yt/core/logging/log_manager.h>
#include <util/string/builder.h>

int main(int argc, const char** argv) {
    auto config = NCrypta::ParsePbOptionsExtended<TExpStatsProxyConfig>(argc, argv);

    InitGlobalLog2Console(TLOG_INFO);
    {
        using namespace NYT::NLogging;
        TLogManager::Get()->Configure(TLogManagerConfig::CreateStderrLogger(ELogLevel::Info));
    }

    INFO_LOG << "Listening at: " << config.GetListenAt() << ", using " << config.GetThreads() <<  " threads" << Endl;

    auto ssr = NNeh::CreateLoop();
    NCrypta::NProxyExpStats::TRequestHandler server(ssr, config.GetListenAt());
    ssr->ForkLoop(config.GetThreads());

    while (true) {
        Sleep(TDuration::Seconds(1));
    }
}
