#include <ads/bsyeti/exp_stats/lib/exp.h>
#include <crypta/lib/java/experiments/proto/experiment.pb.h>
#include <library/cpp/protobuf/json/proto2json.h>
#include <util/string/subst.h>

#include <memory>
#include <wordexp.h>

namespace NCrypta::NProxyExpStats {

NExpStats::TExpStatsArgs GetExpStatsArgs(const TString& cmd) {
    auto args = std::shared_ptr<wordexp_t>(new wordexp_t, [](wordexp_t* we) {
        wordfree(we);
        delete we;
    });

    Y_ENSURE(!wordexp(cmd.c_str(), args.get(), 0), "Failed to parse arguments.");
    Y_ENSURE(args->we_wordc > 1, "Invalid input, only single argument found.");

    NExpStats::TExpStatsArgs expArgs;
    TString errorMsg;
    Y_ENSURE(
        NGetoptPb::GetoptPb(
            args->we_wordc, const_cast<const char**>(args->we_wordv), expArgs, errorMsg, { .DumpConfig = false }
        ),
        errorMsg
    );

    return expArgs;
}

NExperiments::TExperimentStats ToExperimentsStatsProto(const TVector<NYT::TNode> preparedData) {
     NExperiments::TExperimentStats stats{};

    for (const auto& row : preparedData) {
        auto addedRow = stats.AddRows();
        for (auto&& [key, value] : row.AsMap()) {
            const auto& attributes = value.GetAttributes();
            auto& addedValue = (*addedRow->MutableValues())[key];
            addedValue.SetRepr(value.ConvertTo<TString>());
            if (attributes["Value"].IsDouble()) {
                addedValue.SetValue(attributes["Value"].AsDouble());
            }
            if (attributes["Deviation"].IsDouble()) {
                addedValue.SetDeviation(attributes["Deviation"].AsDouble());
            }
            if (attributes["Delta"].IsDouble()) {
                addedValue.SetDelta(attributes["Delta"].AsDouble());
            }
        }
    }

    return stats;
}

TString DoExpStatsRequest(const TString& cmd, const TString& serialize) {
    auto args = GetExpStatsArgs(cmd);
    NExpStats::SetTokenFromEnv(args);

    TVector<TString> printFields;
    TVector<NYT::TNode> preparedData = NExpStats::RunMetrics(args, &printFields);

    auto stats = ToExperimentsStatsProto(preparedData);
    if (serialize == "string") {
        TString reply;
        Y_PROTOBUF_SUPPRESS_NODISCARD stats.SerializeToString(&reply);
        return reply;
    } else {
        auto reply = NProtobufJson::Proto2Json(stats, {.WriteNanAsString = true});
        SubstGlobal(reply, ":\"nan\"", ":\"NaN\"");
        return reply;
    }
}

}
