#pragma once

#include <crypta/lib/native/metrics_helper/metrics_helper.h>

#include <library/cpp/neh/neh.h>
#include <library/cpp/neh/rpc.h>
#include <library/cpp/neh/http_common.h>

#include <util/generic/hash.h>

namespace NCrypta::NProxyExpStats {
    class TRequestHandler {
    public:
        TRequestHandler(NNeh::IServicesRef& server, const TString& listenAt);
        void ServeRequest(const NNeh::IRequestRef& r);
    private:
        void Pong(const NNeh::IRequestRef& r);
        void ProxyExpStats(const NNeh::IRequestRef& r);
        void Solomon(const NNeh::IRequestRef& r);

        TString Hostname;
        NCryptaSolomonMetrics::TMetricsHelper Metrics;
        THashMap<TString, std::function<void (const NNeh::IRequestRef& r)>> RouteMap;
    };
}
