#include "request_logger.h"
#include <library/cpp/neh/http_common.h>
#include <library/cpp/logger/global/global.h>

namespace NCrypta::NProxyExpStats {
    TRequestLogger::TRequestLogger(const ::NNeh::IRequestRef& r, const TString& replyCode)
    : Start(TInstant::Now())
    , Service(r->Service())
    , Query(dynamic_cast<NNeh::IHttpRequest*>(r.Get())->Cgi())
    , RemoteHost(r->RemoteHost())
    , ReplyCode(replyCode)
    {
    }

    TRequestLogger::~TRequestLogger() {
        Reply << RemoteHost
            << " " << ReplyCode
            << " /" << Service
            << (Query.empty() ? "" : "?") << Query
            << " '" << Message << "' "
            << GetDuration().SecondsFloat()
            << Endl;
        INFO_LOG << Reply;
    }

    TRequestLogger& TRequestLogger::SetCode(const TString& code) {
        ReplyCode = code;
        return *this;
    }

    TDuration TRequestLogger::GetDuration() const {
        return TInstant::Now() - Start;
    }
}
