#pragma once

#include <library/cpp/neh/rpc.h>
#include <util/string/builder.h>

namespace NCrypta::NProxyExpStats {
    class TRequestLogger {
    public:
        TRequestLogger(const ::NNeh::IRequestRef& r, const TString& replyCode = "200");
        ~TRequestLogger();
        TDuration GetDuration() const;

        TRequestLogger& SetCode(const TString& code);
        template <typename T> TRequestLogger& Write(T&& more) {
            Message << more;
            return *this;
        }

    private:
        TInstant Start;
        TString Service;
        TString Query;
        TString RemoteHost;
        TString ReplyCode;
        TStringBuilder Message;
        TStringBuilder Reply;
    };
}
