"""Task DirectByTypes.
   Create link in crypta/public to direct tables (type -> type)
"""

import crypta.lib.python.bt.conf.conf as conf

from crypta.graph.acl.matching_acl import get_acl
from crypta.graph.publish.lib.link_publisher import MatchingPublicLinks


class DirectLinkPublisher(object):
    def __init__(self, yt, generate_date, run_date):
        self.yt = yt
        self.generate_date = generate_date
        self.run_date = run_date

    @property
    def base_path(self):
        return conf.direct_config.paths.directbytypes.base_path

    def run(self):
        public_path = conf.direct_config.paths.directbytypes.public_path
        public_links = MatchingPublicLinks(self.yt, get_acl())
        # CRYPTR-643 TODO: should this be called before?
        # public_links.publish_soup_links(base_path, public_path)
        public_links.publish_matching_links(self.base_path, public_path)
