import contextlib
import crypta.lib.python.bt.conf.conf as conf

from crypta.lib.python.bt.tasks import YtTask
from crypta.lib.python.bt.workflow import IndependentTask

from crypta.graph.acl.matching_acl import MatchingAcl
from crypta.graph.publish.lib.link_publisher import MatchingPublicLinks
from crypta.graph.publish.lib.transfer import copy_to_cluster


class CopySoup(YtTask, IndependentTask):
    def run(self, **kwargs):
        base_path = conf.publish_config.paths.copysoup.soup
        public_path = conf.publish_config.paths.directbytypes.public_path
        acl = MatchingAcl()
        links = MatchingPublicLinks(self.yt, acl)
        links.publish_soup_links(base_path, public_path)
        # make households links too
        links.publish_households_links(
            conf.publish_config.paths.households.base_path, conf.publish_config.paths.households.public_path
        )
        links.publish_staff_links(
            conf.publish_config.paths.staff.base_path, conf.publish_config.paths.staff.public_path
        )

    def transfer(self):
        copy_to_cluster("//home/crypta/public/matching/by_id/staff/raw", "//home/crypta/public/matching/by_id/staff/raw")

    @contextlib.contextmanager
    def run_context(self):
        with super(CopySoup, self).run_context() as ctx:
            yield ctx
        self.transfer()
