#pragma once

#include <ads/bsyeti/libs/proto_utils/profile_desc.h>
#include <ads/bsyeti/big_rt/lib/processing/shard_processor/stateful/processor.h>
#include <ads/bsyeti/big_rt/lib/queue/message_batch/message_batch.h>

#include <crypta/graph/rt/brusilov/proto/state.pb.h>
#include <crypta/graph/rt/events/proto/event.pb.h>
#include <crypta/graph/rt/lib/state_managers/vulture/all.h>

#include <library/cpp/framing/unpacker.h>


namespace NBrusilov {
    using TEventMessage = NCrypta::NEvent::TSimpleEventMessage;
    using TVultureEvent = NCrypta::NEvent::TVultureEvent;
    using TVultureConfig = NCrypta::NBrusilov::TStateProcessorConfig;

    using TVultureProcessorBase = NBigRT::TStatefulShardProcessor<
        TString,                   // StateId
        NRtCrypta::TVultureState,  // State
        NRtCrypta::TVultureState>; // Chunk

    class TVultureProcessor: public TVultureProcessorBase {
    public:
        TVultureProcessor(TVultureProcessor::TConstructionArgs spArgs,
                          const TVultureConfig& config);

        TVultureProcessor::TGroupedChunk PrepareGroupedChunk(TString dataSource,
                                                             TVultureProcessor::TManager& stateManager,
                                                             NBigRT::TMessageBatch data) override;

        void ProcessGroupedChunk(TString dataSource, TVultureProcessor::TGroupedChunk groupedRows) override;
        NSFStats::TSolomonContext GetStatsContext(TVector<NSFStats::TSolomonContext::TLabel> labels);

    private:
        const TVultureConfig& Config;
    };
}
