#include <crypta/graph/rt/events/events.h>
#include <crypta/graph/rt/events/messages.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NCrypta::NEvent;

Y_UNIT_TEST_SUITE(TEventsUnpack) {
    Y_UNIT_TEST(PackUnpack) {
        TSoupEvent content{};
        content.SetCryptaId1(1);
        content.SetCryptaId2(2);

        TEventMessage msg{};
        Pack(msg, content);
        content.Clear();

        UNIT_ASSERT(Unpack(msg, content));
        UNIT_ASSERT_VALUES_EQUAL(1, content.GetCryptaId1());
        UNIT_ASSERT_VALUES_EQUAL(2, content.GetCryptaId2());

        msg.Clear();
        UNIT_ASSERT(!Unpack(msg, content));
    }

    Y_UNIT_TEST(UnpackAny) {
        TSoupEvent content{};
        content.SetCryptaId1(1);
        content.SetCryptaId2(2);

        TEventMessage msg;
        Pack(msg, content);

        auto body{UnpackAny(msg)};
        UNIT_ASSERT(body);

        auto& dContent{static_cast<TSoupEvent&>(*body)};
        UNIT_ASSERT_VALUES_EQUAL(1, dContent.GetCryptaId1());
        UNIT_ASSERT_VALUES_EQUAL(2, dContent.GetCryptaId2());
    }

    Y_UNIT_TEST(UnpackAnyExceptions) {
        TSoupEvent content{};
        content.SetCryptaId1(1);
        content.SetCryptaId2(2);

        TEventMessage msg;
        Pack(msg, content);

        UNIT_ASSERT(UnpackAny(msg));

        TEventMessage malformedBody{msg};
        malformedBody.SetBody("some text");
        UNIT_ASSERT_EXCEPTION(UnpackAny(malformedBody), TMessageParsingException);
    }

    Y_UNIT_TEST(GetProcessingOptions) {
        const auto& option{GetProcessingOptions(EMessageType::SOUP)};
        UNIT_ASSERT_VALUES_EQUAL("soup", option.ChunkType);
        UNIT_ASSERT(!option.KeepInCache);
        // check that on invalid message type function does not segfault
        UNIT_ASSERT_EXCEPTION(GetProcessingOptions(static_cast<EMessageType>(100500)), TUnknownMessageException);
    }
}
