#!/bin/bash

function alert() {
    RED='\033[0;31m'
    NC='\033[0m'
    >&2 printf "${RED}$1${NC}\n"    
}

function msg() {
    >&2 printf "$1\n"    
}

function requires() {
    varname="$1"
    if [ -z "${!varname}" ]
    then
        alert "\"$varname\" env variable required!"
        exit 1
    else
        msg "\"$varname\" env variable is ok."
    fi
}

function require_file() {
    filename="$1"
    if [ ! -f "${filename}" ]
    then
        alert "\"$filename\" file does not exist!"
        exit 1
    else
        msg "\"$filename\" file is ok."
    fi
}

requires YT_TOKEN
requires CRYPTA_TVM_ID
requires CRYPTA_TVM_SECRET

# config_file="/conf/${CRYPTA_ENV:-test}.${DEPLOY_NODE_DC:-all}.json"
config_file="/conf/${CRYPTA_ENV:-test}.json"
# config_file="/conf/prod.json"
require_file $config_file

cd /herschel
mkdir -p tvm_cache
truncate --size 0 herschel.log

./herschel \
    --config-json $config_file \
    --global-log /dev/stdout \
    --port 80
