yson_attrs="{
    dynamic=%true;
    schema=[
        {name=Hash;type=uint64;sort_order=ascending;expression=\"farm_hash(Fp)\"};
        {name=Fp;type=string;sort_order=ascending};
        {name=State;type=string};
        {name=Codec;type=string};
        {name=Uids;type=string};
    ]
}";
table_path="//home/crypta/production/rtsklejka/state/herschel_state";


yt --proxy markov create --type replicated_table --attributes $yson_attrs --path $table_path --recursive ;
yt --proxy arnold create --type table --attributes $yson_attrs --path $table_path --recursive ;
yt --proxy hahn create --type table --attributes $yson_attrs --path $table_path --recursive ;

yt --proxy markov set $table_path'/@min_data_ttl' 0;
yt --proxy markov set $table_path'/@max_data_ttl' $(expr 1000 \* 60 \* 60 \* 60);
yt --proxy markov set $table_path'/@max_data_versions' 1;
yt --proxy markov set $table_path'/@min_data_versions' 0;
yt --proxy markov set $table_path'/@replicated_table_options/enable_replicated_table_tracker' '%true'

yt --proxy markov create table_replica --attr '{
  table_path="'$table_path'";
  cluster_name="arnold";
  replica_path="'$table_path'";
}';

yt --proxy markov create table_replica --attr '{
  table_path="'$table_path'";
  cluster_name="hahn";
  replica_path="'$table_path'";
}';

# yt --proxy markov get '//home/crypta/production/rtsklejka/state/herschel_state/@replicas';
# установить реплики включить `yt --proxy markov alter-table-replica --enable`;

make_on_cluster() {
    cluster=$1
    replica_id=$2
    
    yt --proxy $cluster unmount-table $table_path --sync;
    yt --proxy $cluster set $table_path'/@primary_medium' '"default"';
    yt --proxy $cluster set $table_path'/@in_memory_mode' '"uncompressed"';
    yt --proxy $cluster alter-table --upstream-replica-id $replica_id $table_path ;
    yt --proxy $cluster mount-table $table_path --sync;
}

make_on_cluster arnold 1d170-97440-40502c5-f4d2dcd7 ;
make_on_cluster hahn 1d170-97adf-40502c5-d8c35be4 ;
