# for tests

yson_attrs="{
    dynamic=%true;
    schema=[
        {name=Hash;type=uint64;sort_order=ascending;expression=\"bigb_hash(UniqId) % 768\"};
        {name=UniqId;type=string;sort_order=ascending};
        {name=State;type=string};
        {name=CompressedInfo;type=string};
        {name=EraTs;type=uint64};
        {name=RtTs;type=uint64};
    ]
}";
table_path="//home/crypta/production/rtsklejka/state/vulture";


yt --proxy markov create --type replicated_table --attributes $yson_attrs --path $table_path --recursive ;
yt --proxy seneca-sas create --type table --attributes $yson_attrs --path $table_path --recursive ;
yt --proxy seneca-man create --type table --attributes $yson_attrs --path $table_path --recursive ;
yt --proxy seneca-vla create --type table --attributes $yson_attrs --patыh $table_path --recursive ;

set_ttl() {
    cluster=$1
    yt --proxy $cluster set $table_path'/@min_data_ttl' 0;
    yt --proxy $cluster set $table_path'/@max_data_ttl' $(expr 1000 \* 60 \* 60 \* 60);  # 60h
    yt --proxy $cluster set $table_path'/@max_data_versions' 1;
    yt --proxy $cluster set $table_path'/@min_data_versions' 0;
    yt --proxy $cluster set $table_path'/@replicated_table_options/enable_replicated_table_tracker' '%true'
}

set_ttl markov
set_ttl seneca-sas
set_ttl seneca-vla
set_ttl seneca-man

yt --proxy markov create table_replica --attr '{
  table_path="'$table_path'";
  cluster_name="seneca-sas";
  replica_path="'$table_path'";
}';

yt --proxy markov create table_replica --attr '{
  table_path="'$table_path'";
  cluster_name="seneca-man";
  replica_path="'$table_path'";
}';

yt --proxy markov create table_replica --attr '{
  table_path="'$table_path'";
  cluster_name="seneca-vla";
  replica_path="'$table_path'";
}';

# yt --proxy markov get '//home/crypta/production/rtsklejka/state/herschel_state/@replicas';
# # установить реплики включить `yt --proxy markov alter-table-replica --enable`;

make_on_cluster() {
    cluster=$1
    replica_id=$2
    
    yt --proxy $cluster unmount-table $table_path --sync;
    yt --proxy $cluster set $table_path'/@primary_medium' '"ssd_blobs"';
    yt --proxy $cluster set $table_path'/@in_memory_mode' '"uncompressed"';
    yt --proxy $cluster alter-table --upstream-replica-id $replica_id $table_path ;
    yt --proxy $cluster mount-table $table_path --sync;
}

make_on_cluster seneca-sas 3e13b-3f1f6-3ee0191-ad40b005 ;
make_on_cluster seneca-man 2ba6a-8364a-4070191-157df349 ;
make_on_cluster seneca-vla 2f495-11bbb3-4120191-41a04809 ;
