#pragma once

#include "features_calculator.h"

#include <crypta/graph/rt/fp/model/proto/stats.pb.h>
#include <crypta/graph/rt/fp/model/proto/catboost_applier_result.pb.h>
#include <crypta/graph/rt/fp/model/proto/catboost_applier_score.pb.h>

#include <catboost/libs/model/model.h>
#include <util/generic/vector.h>

namespace NCrypta {
    class THerschelCatboostApplier {
    public:
        THerschelCatboostApplier(const THerschelCatboostApplierScore& thresholds);
        THerschelCatboostApplier(const NGeobase::TLookup& lookup, const TString& modelFile, const THerschelCatboostApplierScore& thresholds);
        THerschelCatboostApplier(const NGeobase::TLookup& lookup, const TString& modelFile, const TString& thresholdsFile);
        THerschelCatboostApplierResult Apply(const TStringBuf& ip, const TStringBuf& useragent, const THerschelStats& herschelStats) const;
        THerschelCatboostApplierScore Score(const TStringBuf& ip, const TStringBuf& useragent, const THerschelStats& herschelStats) const;

    private:
        double ApplyCatboost(const TFeatures& features) const;
        NCB::NModelEvaluation::TConstModelEvaluatorPtr GetEvaluator() const;

        const THerschelFeaturesCalculator FeaturesCalculator; 
        const TFullModel Model;
        const THerschelCatboostApplierScore Thresholds;
    };
};
