#pragma once

#include <crypta/graph/rt/fp/model/proto/stats.pb.h>

#include <library/cpp/geobase/lookup.hpp>
#include <library/cpp/ipreg/address.h>
#include <library/cpp/resource/resource.h>
#include <metrika/uatraits/include/uatraits/detector.hpp>
#include <util/generic/vector.h>


namespace NCrypta {
    struct TFeatures {
        TVector<float> FloatFeatures;
        TVector<TString> CategoricalFeatures;
    };

    class THerschelFeaturesCalculator {
    public:
        struct TKeyTypeFeatures {
            float UseBrowser;
            float UseDevice;
            float UseIp;
            float UseUseragent;
        };

        struct TKeyTypeFeaturesByKeyType {
            const TKeyTypeFeatures Ip;
            const TKeyTypeFeatures IpUseragent;
        };

        THerschelFeaturesCalculator(const NGeobase::TLookup& lookup);

        void UpdateKeyTypeFeatures(TFeatures& features, const TKeyTypeFeatures& keyFeatures) const;
        TFeatures GetFeatures(const TStringBuf& ip, const TStringBuf& useragent, const THerschelStats& herschelStats) const;

        static const TKeyTypeFeaturesByKeyType KeyTypeFeaturesByKeyType; 
    private:
        const NGeobase::TLookup& Lookup;
        const THolder<uatraits::detector> UATraitsDetector;
    };
};
