#!/bin/bash
export REGISTRY=registry.yandex.net/crypta/rtfp-resharder

set -e -o pipefail
set -x

cd "$(dirname "$0")"

ya package \
    --docker package.json \
    --docker-network host \
    --docker-registry registry.yandex.net \
    --docker-repository crypta

docker image ls $REGISTRY
IMAGE=$(docker image ls $REGISTRY -q | head -1)

source ./env.sh &>/dev/null
docker run \
    --network host \
    -e YT_TOKEN \
    -e CRYPTA_TVM_ID \
    -e CRYPTA_TVM_SECRET \
    -d $IMAGE

docker logs $(docker ps -q) -f
