#include "algo.h"

#include <functional>

#include <util/digest/murmur.h>
#include <util/generic/yexception.h>
#include <crypta/graph/rt/events/proto/fp.pb.h>

namespace {
    using namespace NResharder;

    // @brief IRowParser implementation for CryptaId algo
    class TShardFingerprint: public NBigRT::IShardingAlgorithm {
    public:
        TShardFingerprint() {
        }

        ui32 Shard(const NBigRT::TRow& row) const override {
            const auto& msg{dynamic_cast<NCrypta::NEvent::TFpEvent*>(row.Message.Get())};
            if (msg->HasFingerprintHash() && msg->GetFingerprintHash() != 0) {
                return msg->GetFingerprintHash();
            } else {
                TString key{};
                Y_PROTOBUF_SUPPRESS_NODISCARD msg->GetFingerprint().SerializeToString(&key);
                const auto& hash{TMurmurHash<ui64>{}(key.data(), key.size())};
                return hash;
            }
        }
    };
}

namespace NResharder {
    NBigRT::IShardingAlgorithmPtr MakeSharder(const TString& algorithm) {
        if (algorithm == "Fingerprint") {
            return MakeHolder<TShardFingerprint>();
        } else {
            return NBigRT::MakeSharder(algorithm);
        }
    }
}
