#pragma once

#include <crypta/graph/rt/lib/parsers/parsers.h>
#include <crypta/graph/rt/fp/rows_processor/proto/config.pb.h>

namespace NResharder {
    class TRowsProcessorConfig;
    // @brief create parser for log records according to config and schema
    NRtSklejka::IRowParserPtr MakeParser(const NProtoBuf::Descriptor* schema, const TRowsProcessorConfig::TParser& config);

    class TInvalidFormatError : public yexception {
    };

    class TNoIdsError : public yexception {
    };

    class TNoFpsError : public yexception {
    };

    class TIspError : public yexception {
    };

    class TObsoleteError : public yexception {
    };

    class TDebounceError : public yexception {
    };

    class TSamplingError : public yexception {
    };
}
