#include "debounce_cache.h"
#include <ads/bsyeti/libs/cache/concurrent_cache.h>

namespace {
    using TCacheBase = NBSYeti::TShardedTimedFIFOCache<NRtCrypta::TKey, ui64>;
}

namespace NRtCrypta {
    struct TDebounceCache::TImpl : public TCacheBase {
        TImpl(TStringBuf id, const TDebounceConfig& config)
            : TCacheBase(
                "dbc_" + TString{id},
                config.GetSize(),
                TDuration::Seconds(config.GetLifetime())
            ) {
        }
    };

    TDebounceCache::TDebounceCache(TStringBuf debounceId, const TDebounceConfig& config)
        : Impl_(NYT::New<TImpl>(debounceId, config))
        , defaultDuration{config.GetLifetime()} {
    }

    TDebounceCache::~TDebounceCache() {
    }

    TMaybe<TDuration> TDebounceCache::Pull(const TKey& key) const {
        return Pull(key, defaultDuration);
    }

    TMaybe<TDuration> TDebounceCache::Pull(const TKey& key, const ui64& cacheDuration) const {
        auto maxCacheDuration{TDuration::Seconds(cacheDuration)};
        if (auto item{Impl_->Find(key, maxCacheDuration)}) {
            return TDuration::MicroSeconds(
                TInstant::Now().MicroSeconds() - item->GetValue()
            );
        }
        return Nothing();
    }

    bool TDebounceCache::Push(const TKey& key) {
        Impl_->Update(key, TInstant::Now().MicroSeconds());
        return true;
    }
}
