#pragma once

#include <ads/bsyeti/libs/cache/item.h>
#include <ads/bsyeti/libs/cache/proto/config.pb.h>
#include <yt/yt/core/misc/intrusive_ptr.h>
#include <util/generic/buffer.h>
#include <util/generic/maybe.h>
#include <util/generic/vector.h>

namespace NRtCrypta {
    using TDebounceConfig = typename NCSR::TCacheConfig;
    using TKey = TString;  // todo: make template

    class TDebounceCache {
    public:
        TDebounceCache(TStringBuf debounceId, const TDebounceConfig& config);
        ~TDebounceCache();

        TMaybe<TDuration> Pull(const TKey& key) const;
        TMaybe<TDuration> Pull(const TKey& key, const ui64& cacheDuration) const;
        bool Push(const TKey& key);

    private:
        struct TImpl;
        const NYT::TIntrusivePtr<TImpl> Impl_;
        const ui64 defaultDuration;
    };
}
