#include <iosfwd>

#include <library/cpp/testing/unittest/registar.h>
#include <crypta/graph/rt/lib/debounce_cache/debounce_cache.h>

#define UNIT_ASSERT_TRUE(Val)  UNIT_ASSERT((Val))
#define UNIT_ASSERT_FALSE(Val) UNIT_ASSERT(!(Val))

Y_UNIT_TEST_SUITE(TestDebounceCache) {

    static const ui32 cacheSize{1600};
    static const ui32 cacheLifetimeInSeconds{3};

    Y_UNIT_TEST(TEST_debounce_cases_miss_empty) {
        NCSR::TCacheConfig cfg{};
        NRtCrypta::TDebounceCache cache{"deb", cfg};
        // check key not in cache (empty)
        UNIT_ASSERT_FALSE(cache.Pull("key").Defined());
    }

    Y_UNIT_TEST(TEST_debounce_cases_miss_limit) {
        NCSR::TCacheConfig cfg{};
        cfg.SetSize(cacheSize);
        NRtCrypta::TDebounceCache cache{"deb", cfg};
        // check key not in cache (overlimit)
        cache.Push("key");
        UNIT_ASSERT_TRUE(cache.Pull("key").Defined());
        cache.Push("key-0key-0key-0key-0key-0key-0key-0key-0key-0key-0key-0");
        cache.Push("key-1key-1key-1key-1key-1key-1key-1key-1key-1key-1key-1");
        cache.Push("key-2key-2key-2key-2key-2key-2key-2key-2key-2key-2key-2");
        cache.Push("key-3key-3key-3key-3key-3key-3key-3key-3key-3key-3key-3");
        cache.Push("key-4key-4key-4key-4key-4key-4key-4key-4key-4key-4key-4");
        cache.Push("key-5key-5key-5key-5key-5key-5key-5key-5key-5key-5key-5");
        cache.Push("key-6key-6key-6key-6key-6key-6key-6key-6key-6key-6key-6");
        cache.Push("key-7key-7key-7key-7key-7key-7key-7key-7key-7key-7key-7");
        cache.Push("key-8key-8key-8key-8key-8key-8key-8key-8key-8key-8key-8");
        cache.Push("key-9key-9key-9key-9key-9key-9key-9key-9key-9key-9key-9");
        UNIT_ASSERT_FALSE(cache.Pull("key").Defined());
    }

    Y_UNIT_TEST(TEST_debounce_cases_ok_hit) {
        NCSR::TCacheConfig cfg{};
        NRtCrypta::TDebounceCache cache{"deb", cfg};
        // check key in cache (empty)
        cache.Push("key");
        UNIT_ASSERT_TRUE(cache.Pull("key").Defined());
        UNIT_ASSERT_FALSE(cache.Pull("ley").Defined());
    }

    // Y_UNIT_TEST(TEST_debounce_cases_ok_hit_ui64) {
    //     NCSR::TCacheConfig cfg{};
    //     NRtCrypta::TDebounceCache<ui64> cache{"deb", cfg};
    //     // check key in cache (empty)
    //     cache.Push(42);
    //     UNIT_ASSERT_TRUE(cache.Pull(42).Defined());
    //     UNIT_ASSERT_FALSE(cache.Pull(43).Defined());
    // }

    Y_UNIT_TEST(TEST_debounce_cases_miss_time) {
        NCSR::TCacheConfig cfg{};
        cfg.SetLifetime(cacheLifetimeInSeconds);
        NRtCrypta::TDebounceCache cache{"deb", cfg};
        // check key in cache (empty)
        cache.Push("key");
        UNIT_ASSERT_TRUE(cache.Pull("key").Defined());
        // wait and recheck
        Sleep(TDuration::Seconds(cacheLifetimeInSeconds + 1));
        UNIT_ASSERT_FALSE(cache.Pull("key").Defined());
    }

    Y_UNIT_TEST(TEST_debounce_cases_miss_fast) {
        NCSR::TCacheConfig cfg{};
        NRtCrypta::TDebounceCache cache{"deb", cfg};
        // check key in cache (empty)
        cache.Push("key");
        UNIT_ASSERT_TRUE(cache.Pull("key").Defined());
        // wait and recheck
        Sleep(TDuration::Seconds(cacheLifetimeInSeconds + 1));
        UNIT_ASSERT_FALSE(cache.Pull("key", 1).Defined());
        UNIT_ASSERT_TRUE(cache.Pull("key").Defined());
    }
}
