#pragma once

#include <ads/bsyeti/big_rt/lib/processing/resharder/rows_processor/parsers.h>
#include <ads/bsyeti/big_rt/lib/processing/resharder/rows_processor/row.h>
#include <logfeller/lib/chunk_splitter/record_context.h>

#include <library/cpp/safe_stats/safe_stats.h>
#include <util/generic/ptr.h>

namespace NRtSklejka {
    class IRowParser {
    public:
        virtual ~IRowParser() = default;
        virtual void Parse(TStringBuf text, NBigRT::TRow& row, NBigRT::TRowsBatch& rows, NBigRT::TParseContext& context) const = 0;
    };

    using IRowParserPtr = THolder<IRowParser>;

    template <typename T>
    class IParser {
    public:
        using TParseResult = T;

        virtual ~IParser() = default;
        virtual T Parse(TStringBuf text, NSFStats::TSolomonContext& ctx) const = 0;
    };

    template<typename T> using IParserPtr = THolder<IParser<T>>;
}
