#include "qyt_batch_multipacker.h"

namespace NRtSklejka {

    TQytBatchMultiPacker::TQytBatchMultiPacker(const ui64 shardsCount, NBigRT::TQytBatchPackerOptions options)
        : ShardedBatchPackers(shardsCount)
        , Options(std::move(options))
    {
    }

    TQytBatchMultiPacker::TQytBatchMultiPacker(const TQytBatchConfig& config)
        : TQytBatchMultiPacker(
            config.GetReshardingModule(), {
                .MaxMessagesCount = config.GetMaxMessagesCount()
            }
        )
    {
    }

    void TQytBatchMultiPacker::Add(const ui64 shard, const google::protobuf::Message& proto) {
        auto& batchPacker = ShardedBatchPackers[shard];
        if (!batchPacker) {
            auto optionsCopy = Options;
            optionsCopy.Shard = shard;
            batchPacker = MakeHolder<NBigRT::TQytBatchPacker>(std::move(optionsCopy));
        }
        batchPacker->Add(proto);
    }

    TVector<NBigRT::TYtQueue::TWriteRow> TQytBatchMultiPacker::Finish() {
        auto result = TVector<NBigRT::TYtQueue::TWriteRow>(Reserve(ShardedBatchPackers.size()));
        for (auto& [shard, batchPacker] : ShardedBatchPackers) {
            auto rowsToWrite = batchPacker->Finish();
            std::move(rowsToWrite.begin(), rowsToWrite.end(), std::back_inserter(result));
        }
        return result;
    }

    void TQytBatchMultiPacker::Clear() {
        ShardedBatchPackers.clear();
    }

}
