#pragma once

#include <crypta/graph/rt/lib/qyt_batch_multipacker/proto/config.pb.h>
#include <ads/bsyeti/big_rt/lib/queue/qyt/batch_packer.h>

namespace NRtSklejka {

    class TQytBatchMultiPacker {
    public:
        explicit TQytBatchMultiPacker(const ui64 shardsCount = 0, NBigRT::TQytBatchPackerOptions options = {});
        explicit TQytBatchMultiPacker(const TQytBatchConfig& config);

        void Add(const ui64 shard, const google::protobuf::Message& proto);
        TVector<NBigRT::TYtQueue::TWriteRow> Finish();
        void Clear();

    private:
        THashMap<ui64, THolder<NBigRT::TQytBatchPacker>> ShardedBatchPackers;
        NBigRT::TQytBatchPackerOptions Options;
    };
}
