#include "build_version.h"

namespace NCrypta {
    void BuildVersionSensors(NSFStats::TSolomonContext ctx) {
        using TLastMetric = NSFStats::TLastMetric<ui64>;
        NSFStats::TSolomonContext sctx{ctx.Detached(), {{"place", "/"}}};
        sctx.Get<TLastMetric>("revision").Set(GetProgramSvnRevision());
        sctx.Get<TLastMetric>("patch").Set(GetArcadiaPatchNumber());
        sctx.Get<TLastMetric>("build_time").Set(GetProgramBuildTimestamp());
        sctx.Get<TLastMetric>("start_time").Set(TInstant::Now().Seconds());
    }
}
