#pragma once

#include <library/cpp/safe_stats/safe_stats.h>

namespace {
    const size_t kMin{60};
    using TDebounceLagMetric = NSFStats::TSolomonThresholdMetric<1, 3, 5, 7, 9, 11, 13, 15, 20, 30, 50, 100>;
    using TMessageLagMetric = NSFStats::TSolomonThresholdMetric<10, 1 * kMin, 3 * kMin, 5 * kMin, 10 * kMin, 20 * kMin, 30 * kMin, 45 * kMin, 60 * kMin, 3 * 60 * kMin>;
}

namespace NCrypta {
    void SetDebounceLag(NSFStats::TSolomonContext& ctx, const TDuration& duration) {
        ctx.Get<TDebounceLagMetric>("debounce_hist").Add(duration.Seconds());
    }

    template <class TEventMessage>
    void SetMessageLag(NSFStats::TSolomonContext& ctx, const TEventMessage& message) {
        const auto now{TInstant::Now()};
        const auto messageTime{TInstant::Seconds(message.GetTimeStamp())};
        if (now < messageTime) {
            ctx.Get<NSFStats::TSumMetric<ui64>>("event_lag_future").Inc(1);
        } else {
            ctx.Get<TMessageLagMetric>("event_lag_hist").Add((now - messageTime).Seconds());
        }
    }
}
