#pragma once

#include "fwd.h"

#include "manager.h"
#include "operator.h"

#include <ads/bsyeti/big_rt/lib/processing/state_manager/generic/factory.h>
#include <ads/bsyeti/big_rt/lib/processing/state_manager/generic/manager.h>

#include <util/generic/ptr.h>


namespace NRtCrypta {
    using namespace NBigRT;

    // State manager factory which handles storage of given proto state
    // with single string id into table passed via table operator.
    template <typename TState>
    class TVultureStateManagerFactory:
        public TGenericStateManagerFactory<TString, TState>
    {
    public:
        using TManager = TVultureStateManager<TState>;

    public:
        explicit TVultureStateManagerFactory(
            TStateManagerConfig managerConfig,
            TDebounceConfig debConfig,
            TVultureStateTableOperator stateOperator,
            NSFStats::TSolomonContext sensorsContext
        );
        explicit TVultureStateManagerFactory(
            TStateManagerConfig managerConfig,
            TDebounceConfig debConfig,
            TVultureStateTableOperator stateOperator,
            const NYT::NProfiling::TTagSet& tags
        );

    public:
        TBaseStateManagerPtr Make(ui64 shard) override;

    protected:
        TVultureStateTableOperator StateOperator;
        TDebounceConfig DebConfig;
    };
}


#include "factory.hxx"
