#pragma once

#include "factory.h"

#include <ads/bsyeti/big_rt/lib/utility/profiling/safe_stats_over_yt.h>

#include <util/generic/yexception.h>


namespace NRtCrypta {
    template <typename TState>
    TVultureStateManagerFactory<TState>::TVultureStateManagerFactory(
        TStateManagerConfig managerConfig,
        TDebounceConfig debConfig,
        TVultureStateTableOperator stateOperator,
        NSFStats::TSolomonContext sensorsContext
    )
        : TGenericStateManagerFactory<TString, TState>(std::move(managerConfig), std::move(sensorsContext))
        , StateOperator(std::move(stateOperator))
        , DebConfig(std::move(debConfig))
    {
    }

    template <typename TState>
    TVultureStateManagerFactory<TState>::TVultureStateManagerFactory(
        TStateManagerConfig managerConfig,
        TDebounceConfig debConfig,
        TVultureStateTableOperator stateOperator,
        const NYT::NProfiling::TTagSet& tags
    )
        : TVultureStateManagerFactory(std::move(managerConfig), std::move(debConfig),
                                      std::move(stateOperator), MakeSolomonContext(tags))
    {
    }

    template <typename TState>
    TBaseStateManagerPtr TVultureStateManagerFactory<TState>::Make(ui64 /*shard*/) {
        return NYT::New<TManager>(
            this->ManagerConfig, DebConfig, StateOperator, this->SensorsContext
        );
    }
}
