#pragma once

#include "fwd.h"

#include "operator.h"

#include <crypta/graph/rt/lib/debounce_cache/debounce_cache.h>
#include <ads/bsyeti/big_rt/lib/processing/state_manager/generic/manager.h>
#include <ads/bsyeti/libs/cache/proto/config.pb.h>

#include <yt/yt/core/actions/public.h>
#include <yt/yt/client/api/public.h>

#include <util/generic/hash.h>
#include <util/generic/ptr.h>


namespace NRtCrypta {
    using namespace NBigRT;

    template <typename TState_>
    class TVultureStateManager:
        public TGenericStateManager<TString, TState_>
    {
    public:
        using typename TGenericStateManager<TString, TState_>::TStateId;
        using typename TGenericStateManager<TString, TState_>::TState;

    private:
        using TBaseRequestPtr = TGenericStateRequestPtr<TStateId, TState>;
        static constexpr TStringBuf DebounceId{"vult"};

    public:
        explicit TVultureStateManager(
            TStateManagerConfig stateConfig,
            TDebounceConfig debConfig,
            TVultureStateTableOperator stateOperator,
            NSFStats::TSolomonContext sensorsContext
        );
        explicit TVultureStateManager(
            TStateManagerConfig stateConfig,
            TDebounceConfig debConfig,
            TVultureStateTableOperator stateOperator,
            const NYT::NProfiling::TTagSet& tags
        );

        NYT::TFuture<
            TVector<TBaseStateRequestPtr>
        > LoadStates(
            TVector<TBaseRequestPtr> requests,
            NYT::NApi::IClientPtr client,
            NYT::NTransactionClient::TTimestamp timestamp
        ) override;

        TBaseStateManager::TStateWriter WriteStates(
            TVector<TBaseRequestPtr> requests
        ) override;

        size_t SpaceUsed(const TState& state) override;

    private:
        TVultureStateTableOperator StateOperator;
        NRtCrypta::TDebounceCache Debounce;
        NSFStats::TSolomonContext SensorsContext;
    };
}


#include "manager.hxx"
