#pragma once

#include <google/protobuf/text_format.h>

#include <yt/yt/client/api/client.h>
#include <yt/yt/client/api/transaction.h>

#include <util/generic/maybe.h>
#include <util/generic/vector.h>


namespace NRtCrypta {
    class TVultureStateTableOperator {
    public:
        struct TOptions {
            TString Table;
            TString KeyPrefix{};
            TString KeyColumn{"UniqId"};
            TString ValueColumn{"CompressedInfo"};
            TString Codec{"zlib-6"};
            TString EraColumn{"EraTs"};
            TString RtColumn{"RtTs"};
            bool WriteOnlyState{true};
        };

    public:
        TVultureStateTableOperator(TOptions options);

        NYT::TFuture<TVector<TString>> Load(
            NYT::NApi::IClientPtr client, const TVector<TString>& keys
        ) const;

        template <typename TState>
        TVector<TState> Parse(const TVector<TString>& rows) const;

        template <typename TState>
        TVector<TString> Serialize(const TVector<TState>& states) const;

        void Write(
            NYT::NApi::ITransactionPtr tx,
            const TVector<TString>& keys, const TVector<TString>& values
        ) const;

    private:
        TOptions Options;
    };
};


#include "operator.hxx"
