#pragma once

#include <library/cpp/blockcodecs/codecs.h>
#include <library/cpp/iterator/zip.h>

#include <yt/yt/client/api/rowset.h>
#include <yt/yt/client/table_client/helpers.h>
#include <yt/yt/client/table_client/name_table.h>
#include <yt/yt/client/table_client/row_buffer.h>
#include <yt/yt/client/table_client/unversioned_row.h>

#include <util/generic/buffer.h>
#include <util/string/builder.h>


namespace NRtCrypta {

    template <typename TState>
    TVector<TState> TVultureStateTableOperator::Parse(
        const TVector<TString>& rows
    ) const {
        TVector<TState> result(Reserve(rows.size()));

        for (auto& row: rows) {
            result.emplace_back();
            Y_PROTOBUF_SUPPRESS_NODISCARD result.back().ParseFromString(row);
        }

        return result;
    }

    template <typename TState>
    TVector<TString> TVultureStateTableOperator::Serialize(
        const TVector<TState>& states
    ) const {
        TVector<TString> values(Reserve(states.size()));

        for (auto& state : states) {
            values.emplace_back();
            Y_PROTOBUF_SUPPRESS_NODISCARD state.SerializeToString(&values.back());
        }

        return values;
    }
}
