#include <util/string/builder.h>
#include <build/scripts/c_templates/svnversion.h>

#include "services.h"

namespace NCrypta {
    class TInfoService: public NNeh::IService {
    public:
        TInfoService()
            : info([]()
        {
                TStringBuilder content{};
                content << "Revision: "
                        << GetProgramSvnRevision()
                        << "\n"
                        << "Patch: "
                        << GetArcadiaPatchNumber()
                        << "\n"
                        << "Build timestamp: "
                        << GetProgramBuildTimestamp()
                        << "\n---\n"
                        << GetProgramSvnVersion()
                        << "\n---\n"
                        ;
                return content;
            }()) {
        }

        void ServeRequest(const NNeh::IRequestRef& request) override {
            NNeh::TData data{info.cbegin(), info.cend()};
            request->SendReply(data);
        }

    private:
        const TString info;
    };

    NNeh::IServiceRef CreateInfoService() {
        return MakeIntrusive<TInfoService>();
    }
}
