#pragma once

#include <crypta/graph/rt/sklejka/cid_resolver/proto/cid_message.pb.h>
#include <crypta/lib/native/identifiers/lib/generic.h>
#include <crypta/lib/native/identifiers/lib/id_types/cryptaid.h>

#include <ads/bsyeti/libs/primitives/proto_types.h>
#include <ads/bsyeti/libs/yt_rpc_client/client.h>
#include <ads/bsyeti/libs/yt_storage/serializable_profile.h>

#include <util/generic/buffer.h>
#include <util/generic/vector.h>

#include <yt/yt/client/table_client/row_buffer.h>
#include <yt/yt/core/actions/future.h>
#include <yt/yt/core/logging/log_manager.h>
#include <yt/yt/core/misc/shutdown.h>


namespace NCrypta {
    using TCryptaIdProtoPack = NCrypta::TCryptaIdMapping;
    using TCryptaIdProtoPackVector = TVector<TCryptaIdProtoPack>;

    using TCryptaIdPair = std::pair<NIdentifiers::TGenericID, NIdentifiers::TCryptaId>;
    using TCryptaIdPairVector = TVector<TCryptaIdPair>;
    class TYtCryptaIdProtosLoader {
    public:
        explicit TYtCryptaIdProtosLoader(const TString& table, const TDuration timeout, const bool syncRead);

        TCryptaIdProtoPackVector LoadRowset(
            const TVector<NIdentifiers::TGenericID>& resolveIds,
            NYT::NApi::IClientPtr client);

    private:
        NYT::TFuture<NYT::NApi::IUnversionedRowsetPtr> LoadRowsetFuture(
            const TVector<NIdentifiers::TGenericID>& resolveIds,
            NYT::NApi::IClientPtr client);
        TVector<std::pair<TBuffer,TBuffer>> ParseRows(NYT::NApi::IUnversionedRowsetPtr rowset);
        TCryptaIdProtoPackVector BuildCryptaIdProtos(NYT::NApi::IUnversionedRowsetPtr rowset);
        TCryptaIdProtoPackVector BuildCryptaIdProtos(const TVector<std::pair<TBuffer,TBuffer>>& rows);

        struct TStaticContext {
            explicit TStaticContext(TDuration timeout, bool syncRead);

            NYT::NApi::TLookupRowsOptions LookupRowsOptions;
            NYT::NTableClient::TNameTablePtr NameTable;
            const int KeyField;
            const int ValueField;
            const TString Codec;
        };

        const TString Table;
        TStaticContext Context;
    };

    class TYtCryptaIdProtosSaver {
    public:
        explicit TYtCryptaIdProtosSaver(const TString& table);

        void SaveRowset(
            const TCryptaIdPairVector& rows,
            NYT::NApi::IClientPtr client);
    private:

        struct TStaticContext {
            explicit TStaticContext();

            NYT::NApi::TModifyRowsOptions ModifyRowsOptions;
            NYT::NTableClient::TNameTablePtr NameTable;
            const int KeyField;
            const int ValueField;
        };

        const TString Table;
        TStaticContext Context;
    };
}
