#pragma once

#include <crypta/graph/rt/sklejka/cid_resolver/lib/config.pb.h>

#include <ads/bsyeti/libs/cache/concurrent_cache.h>
#include <ads/bsyeti/libs/primitives/proto_types.h>

#include <crypta/lib/native/identifiers/lib/generic.h>

#include <yt/yt/client/api/client.h>
#include <library/cpp/safe_stats/safe_stats.h>

#include <util/generic/ptr.h>
#include <util/generic/vector.h>
#include <util/generic/yexception.h>

namespace NCrypta {
    class ICryptaIdResolver: public TThrRefBase {
    public:
        struct TException: yexception {};
        struct TNoResponseException: TException {};

        using TCryptaId = ui64;
        using TChunkRequest = TVector<NIdentifiers::TGenericID>;
        template <class T>
        using TChunkResponse = TVector<TMaybe<T>>;

        virtual ~ICryptaIdResolver() = default;
        void operator&() = delete; // avoid of creating ptr from object on stack

        /*!
         * Returns identifiers by ids
         * Throws TNoResponseException if no response got
         */
        virtual TChunkResponse<TCryptaId> Identify(const TChunkRequest& ids, NSFStats::TSolomonContext& ctx) = 0;
    };

    using TCryptaIdResolverPtr = TIntrusivePtr<ICryptaIdResolver>;
    using TIdKey = NIdentifiers::TGenericID;

    template <class T>
    using TResolverFun = std::function<ICryptaIdResolver::TChunkResponse<T>(const TVector<TIdKey>& keys, ui32 attempt)>;

    struct TCryptaIdResolverData {
        TVector<NYT::NApi::IClientPtr> YtClients;
        TVector<TString> YtClientAliases;
        TStringBuf Table;
        ui32 AttemptsCount;
        TDuration Timeout;
        ui64 MaxCacheSize;
        TDuration MaxCacheDuration;
        ui32 MaxRequestBatchSize;
    };

    TCryptaIdResolverData CreateCryptaIdResolverData(const TCryptaIdResolverConfig& config);

    TCryptaIdResolverPtr CreateCryptaIdResolver(TCryptaIdResolverData&& data);
    TCryptaIdResolverPtr CreateCryptaIdResolver(const TCryptaIdResolverConfig& config);

    template <class T>
    struct TIdentificationCacheSizeGetter {
        size_t operator()(const TIdKey& key, const TMaybe<T>& value) const;
    };

    template <class T>
    using TIdentificationCache = NBSYeti::TShardedTimedFIFOCache<TIdKey, TMaybe<T>, TIdentificationCacheSizeGetter<T>>;

    template <class T>
    ICryptaIdResolver::TChunkResponse<T> DoIdentificationRequest(
        const ICryptaIdResolver::TChunkRequest& ids,
        const TResolverFun<T> rawRequester,
        ui32 attemptsCount,
        ui32 maxRequestBatchSize,
        TIdentificationCache<T>& cache,
        NSFStats::TSolomonContext& ctx);

}
