/*
 * This is not a auto test
 * Use only for develop to make query on real cluster
 */

#include <library/cpp/testing/unittest/registar.h>

#include <crypta/graph/rt/sklejka/cid_resolver/lib/resolver.h>
#include <crypta/lib/native/identifiers/lib/id_types/all.h>

#include <library/cpp/iterator/zip.h>
#include <util/generic/string.h>

#include <library/cpp/string_utils/base64/base64.h>

using namespace NCrypta;

Y_UNIT_TEST_SUITE(ClusterTestSuite) {
    template <class T>
    using TChunkResponse = ICryptaIdResolver::TChunkResponse<T>;
    using TChunkRequest = ICryptaIdResolver::TChunkRequest;
    using TCryptaId = ICryptaIdResolver::TCryptaId;
    using TGenericID = NIdentifiers::TGenericID;

    Y_UNIT_TEST(Test) {
        #if false
        TCryptaIdResolverConfig protoConfig{};

        protoConfig.AddYtClusters("zeno");
        protoConfig.SetTable("//home/crypta/rtsklejka/state/crypta_id");
        protoConfig.SetAttemptsCount(1);
        protoConfig.SetTimeoutMs(1000);
        protoConfig.SetMaxCacheSize(100);
        protoConfig.SetMaxCacheDurationMs(60000);
        Y_UNUSED(protoConfig);

        auto resolverData{CreateCryptaIdResolverData(protoConfig)};
        auto resolver{CreateCryptaIdResolver(std::move(resolverData))};

        // const NIdentifiers::TEmail email{"003i2r8a@yandex.ru"};
        // const TGenericID id{"email", "003i2r8a@yandex.ru"};
        // const auto out{id.Serialize()};

        // TString ser;
        // email.ToProto().SerializeToString(&ser);

        // Cerr << id.GetValue() << " "
        //      << Base64Encode(out) << "\n"
        //      << "CAVCFQoIMDAzaTJyOGESCXlhbmRleC5ydQ==" << "\n"
        //      << Base64Encode(ser) << "\n"
        // ;

        NSFStats::TStats stats;
        NSFStats::TSolomonContext ctx{stats};
        const TChunkRequest request{
            TGenericID{"yandexuid", "4682071601576680669"},
            TGenericID{"yandexuid", "4682071601500000001"},
            TGenericID{"yandexuid", "7206911551598238941"},
            TGenericID{"yandexuid", "8334157561591504093"},
            TGenericID{"gaid", "44f07d46-d179-43fe-87b1-0cd15c51f0d3"},
            TGenericID{"gaid", "19a570d4-e8a9-4d62-8bd9-5e41fcd1f0d3"},
            TGenericID{"gaid", "754649cc-832a-4bac-af6b-a4083d11f0d3"},
            TGenericID{"email", "003i2r8a@yandex.ru"},
            TGenericID{"email", "0lvl6i6mtfh443uqgc@yandex.ru"},
            TGenericID{"email", "2a5avweufrzrhga132@yandex.ru"},
            TGenericID{"email", "non-hit-email@yandex.ru"},
        };

        auto result{resolver->Identify(request, ctx)};
        for (const auto& line : result) {
            Cerr << line << "\n";
        }
        #else
        UNIT_ASSERT(true);
        #endif
    }
}
