#include <library/cpp/testing/unittest/registar.h>
#include <crypta/lib/native/identifiers/lib/generic.h>
#include "utils.h"

Y_UNIT_TEST_SUITE(RTSklejkaUtilsTestSuite) {
    Y_UNIT_TEST(TestGenerateCryptaId) {
        UNIT_ASSERT_EQUAL(12281281158653685790ull, NCrypta::GenerateCryptaId(NIdentifiers::TGenericID{"puid", "205343955"}));
        UNIT_ASSERT_EQUAL(13175940255094843225ull, NCrypta::GenerateCryptaId(NIdentifiers::TGenericID{"yandexuid", "2705483691532376011"}));
        UNIT_ASSERT_EQUAL(14014992901149146610ull, NCrypta::GenerateCryptaId(NIdentifiers::TGenericID{"icookie", "2705483691532376011"}));
    }
}
