#include "utils.h"

namespace NCrypta {
    ui64 GenerateCryptaId(const NIdentifiers::TGenericID& id) {
        // https://a.yandex-team.ru/arc/trunk/arcadia/crypta/graph/matching/model/src/main/java/ru/yandex/crypta/graph2/model/matching/component/ComponentCenter.java?rev=r8329128#L63-66
        TStringBuilder value{};
        value << id.GetValue() << "(" << id.GetTypeString() << ")";
        const auto hash{MurmurHash<ui64>(value.data(), value.size())};
        return hash;
    }
}