#!/bin/bash

function requires() {
    RED='\033[0;31m'
    NC='\033[0m'

    varname="$1"
    if [ -z "${!varname}" ]
    then
        >&2 printf "${RED}\"$varname\" env variable required!${NC}\n"
        exit 1
    else
        >&2 printf "\"$varname\" env variable is ok.\n"
    fi
}

requires YT_TOKEN
requires CRYPTA_TVM_ID
requires CRYPTA_TVM_SECRET
requires CRYPTA_ENV


>&2 printf "Using '%s$' config" "$CRYPTA_ENV"
config_file="/conf/${CRYPTA_ENV:-test}.json"


cd /michurin
mkdir -p tvm_cache

echo "Starting michurin..."
./michurin --config-json "$config_file"
