#pragma once

#include <ads/bsyeti/protos/vulture_messages.pb.h>

#include <crypta/graph/rt/sklejka/lib/utils.h>
#include <crypta/graph/rt/sklejka/michurin/proto/state.pb.h>
#include <crypta/graph/rt/events/events.h>
#include <crypta/graph/rt/events/proto/event.pb.h>
#include <crypta/graph/rt/events/proto/soup.pb.h>

#include <crypta/graph/engine/proto/graph.pb.h>
#include <crypta/graph/engine/graph/lib/split.h>

#include <crypta/lib/native/identifiers/lib/ads/ads.h>
#include <crypta/lib/native/identifiers/lib/generic.h>

#include <util/generic/hash.h>
#include <util/generic/queue.h>
#include <util/generic/vector.h>

namespace NMichurin {
    using TGenericID = NIdentifiers::TGenericID;

    using ESourceType = NCrypta::NSoup::NSourceType::ESourceType;
    using ELogSourceType = NCrypta::NSoup::NLogSource::ELogSourceType;
    using TCryptaId = NIdentifiers::TCryptaId;

    using TEventMessage = NCrypta::NEvent::TEventMessage;
    using TSoupEvent = NCrypta::NEvent::TSoupEvent;

    using TEdgeBetween = NCrypta::NGraphEngine::TEdgeBetween;
    using TEdge = NCrypta::NGraphEngine::TEdge;

    using TEdgeDataTuple = std::tuple<ui32, ui32, ESourceType, ELogSourceType>;
    using TAssociatedUids = NVulture::TAssociatedUids;

    struct TVertexInfo {
        ui32 index;
        ui32 refCount;
    };

    class TGraphHandler {
    public:
        TGraphHandler(NCrypta::NGraphEngine::TGraph* graph);
        bool ProcessEventMessage(const TEventMessage& eventMessage);
        bool ProcessSoupEvent(const TSoupEvent& soupEvent);
        void Merge(const TGraphHandler& other);
        std::pair<TEdge*, bool> AddEdge(const TEdgeBetween& eventMessage, ui32 timestamp);
        THashSet<TGenericID> LimitEdges(int limit);
        THashMap<TGenericID, TAssociatedUids> ConvertToVulture() const;
        const TVector<TSoupEvent> ToSoup() const;

        void clear();

        ui64 GetId() const {
            return graph->GetId();
        }

        void SetId(ui64 cryptaid) {
            graph->SetId(cryptaid);
        }

        ui32 size() const {
            return graph->GetEdges().size();
        };

        bool contains(const TGenericID& vertex) const {
            return vertexToIndexCountMap.contains(vertex);
        };

        void RebuildState(const TVector<TSoupEvent>& soupToKeep);
        THashMap<ui64, TVector<TSoupEvent>> Split(bool forceEdgesStrong=false);

    private:
        //holds index and number of times a vertex is referenced by edges in a graph
        THashMap<TGenericID, TVertexInfo> vertexToIndexCountMap;

        THashMap<TEdgeDataTuple, ui32> edgeToIndexMap;
        NCrypta::NGraphEngine::TGraph* graph;

        TVertexInfo& AddVertex(const TGenericID& vertex);

        // TODO: Remove
        void DropVertex(const TGenericID& vertex);
        TVector<TGenericID> DropOldestEdge();
    };

    TEdgeDataTuple edgeDataFromEdge(const NCrypta::NGraphEngine::TEdge& edge);
}
